import pandas as pd
import numpy as np
import pickle

atp_tennis = pd.read_csv("atp_tennis.csv")

for player in top_10_player_names:
    for round_name in rounds:
        if round_name == 'Early Round':
            # Filter the dataset to only include matches played by the player in the early rounds
            player_round_matches = grass_matches[((grass_matches['Round'] == '1st Round') | (grass_matches['Round'] == '2nd Round') | (grass_matches['Round'] == '3rd Round') | (grass_matches['Round'] == '4th Round')) & ((grass_matches['Player_1'] == player) | (grass_matches['Player_2'] == player))]
        else:
            # Filter the dataset to only include matches played by the player in the specific round
            player_round_matches = grass_matches[(grass_matches['Round'] == round_name) & ((grass_matches['Player_1'] == player) | (grass_matches['Player_2'] == player))]
        
        # Calculate the number of matches played
        matches_played = len(player_round_matches)
        
        # Calculate the number of matches won
        matches_won = len(player_round_matches[player_round_matches['Winner'] == player])
        
        # Calculate the win rate
        win_rate = (matches_won / matches_played) * 100 if matches_played > 0 else 0

print(win_rate)
pickle.dump(win_rate,open("./ref_result/win_rate.pkl","wb"))